function [mu,dmudtheta] = poissonrate(theta,parameters)
% Returns the Poisson-rates for all pixels and all first order
% derivatives w.r.t. the parameters theta.
%
% Sjoerd Stallinga, TU Delft

% (C) Copyright 2018
% All rights reserved
% Department of Imaging Physics
% Faculty of Applied Sciences
% Delft University of Technology
% Delft, The Netherlands   

numparams = length(theta);
Mx = parameters.Mx;
My = parameters.My;
Mz = parameters.Mz;
parameters.xemit = theta(1);
parameters.yemit = theta(2);
Nph = theta(numparams-1);
bg = theta(numparams);
switch parameters.fitmodel
  case 'xyz'
    parameters.zemit = theta(3);
  case 'xylambda'
    parameters.lambda = theta(3);
  case 'xyzlambda'
    parameters.zemit = theta(3);
    parameters.lambda = theta(4);
  case 'aberrations'
    parameters.zemit = theta(3);
    parameters.aberrations(:,3) = theta(4:numparams-2); 
end

% Evaluate PSF and PSF derivatives
[~,~,wavevector,wavevectorzimm,Waberration,allzernikes,PupilMatrix] = ...
  get_pupil_matrix(parameters);
[~,~,FieldMatrix,FieldMatrixDerivatives] = ...
  get_field_matrix_derivatives(PupilMatrix,wavevector,wavevectorzimm,Waberration,allzernikes,parameters);
[PSF,PSFderivatives] = get_psfs_derivatives(FieldMatrix,FieldMatrixDerivatives,parameters);

% get Poisson rate and derivatives
mu = Nph*PSF+bg;

% get derivatives of Poisson rate w.r.t. fit parameters
% if z-dimension is singleton we must make a difference
if Mz==1
  dmudtheta = zeros(Mx,My,numparams);
  for jp = 1:numparams-2
    dmudtheta(:,:,jp) = Nph*PSFderivatives(:,:,1,jp);
  end
  dmudtheta(:,:,numparams-1) = PSF;
  dmudtheta(:,:,numparams) = ones(size(PSF));
else
  dmudtheta = zeros(Mx,My,Mz,numparams);
  for jp = 1:numparams-2
    dmudtheta(:,:,:,jp) = Nph*PSFderivatives(:,:,:,jp);
  end
  dmudtheta(:,:,:,numparams-1) = PSF;
  dmudtheta(:,:,:,numparams) = ones(size(PSF));
end

end